package šestý;

public class Šestý 
{
    public static void main(String[] args) 
    {
        Fraktál.výpis();
        final int POČET_ITERACÍ = 200;
        final double MEZ = 2.0;
        
        Fraktál f = new Mandelbrot();
        double x = 1.12345;
        int i = 0;
        x = f.první(x);
        while((Math.abs(x) < MEZ) && (i < POČET_ITERACÍ))
        {
            x = f.další(x);
            i++;
        }
        
    }
    
}

interface Fraktál
{
    double další(double x);
    
    default  double první(double x)
    {
        vypišStav(x);
        return další(x);
    }
    
    static void výpis()
    {
        System.out.println("Iterace běží");
    }
    private void vypišStav(double z)
    {
        System.out.println(z);
    }
}

class Mandelbrot implements Fraktál
{
    private double x0;
    @Override
    public double další(double x) 
    {
        return x*x + x0;
    }

    @Override
    public double první(double x) 
    {
        x0 = x;
        return další(x);
    }
    
}

class Julia implements Fraktál
{
    static final double k = 0.2315;
    
    @Override
    public double další(double x) 
    {
        return x*x+k;
    }
    
}